/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTypeTable
extends Attribute {
    private LocalVariable[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable localVariableTypeTable) {
        this(localVariableTypeTable.getNameIndex(), localVariableTypeTable.getLength(), localVariableTypeTable.getLocalVariableTypeTable(), localVariableTypeTable.getConstantPool());
    }

    public LocalVariableTypeTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)17, n, n2, constantPool);
        this.local_variable_type_table = localVariableArray;
    }

    LocalVariableTypeTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[n3];
        for (int i = 0; i < n3; ++i) {
            this.local_variable_type_table[i] = new LocalVariable(dataInput, constantPool);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_type_table.length);
        for (LocalVariable localVariable : this.local_variable_type_table) {
            localVariable.dump(dataOutputStream);
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariable getLocalVariable(int n) {
        for (LocalVariable localVariable : this.local_variable_type_table) {
            if (localVariable.getIndex() != n) continue;
            return localVariable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_type_table = localVariableArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            stringBuilder.append(this.local_variable_type_table[i].toStringShared(true));
            if (i >= this.local_variable_type_table.length - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTypeTable localVariableTypeTable = (LocalVariableTypeTable)this.clone();
        localVariableTypeTable.local_variable_type_table = new LocalVariable[this.local_variable_type_table.length];
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            localVariableTypeTable.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
        }
        localVariableTypeTable.setConstantPool(constantPool);
        return localVariableTypeTable;
    }

    public final int getTableLength() {
        return this.local_variable_type_table == null ? 0 : this.local_variable_type_table.length;
    }
}

