/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ModuleExports;
import com.sun.org.apache.bcel.internal.classfile.ModuleOpens;
import com.sun.org.apache.bcel.internal.classfile.ModuleProvides;
import com.sun.org.apache.bcel.internal.classfile.ModuleRequires;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Module
extends Attribute {
    private final int module_name_index;
    private final int module_flags;
    private final int module_version_index;
    private ModuleRequires[] requires_table;
    private ModuleExports[] exports_table;
    private ModuleOpens[] opens_table;
    private final int uses_count;
    private final int[] uses_index;
    private ModuleProvides[] provides_table;

    Module(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        super((byte)22, n, n2, constantPool);
        int n3;
        int n4;
        int n5;
        this.module_name_index = dataInput.readUnsignedShort();
        this.module_flags = dataInput.readUnsignedShort();
        this.module_version_index = dataInput.readUnsignedShort();
        int n6 = dataInput.readUnsignedShort();
        this.requires_table = new ModuleRequires[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            this.requires_table[n5] = new ModuleRequires(dataInput);
        }
        n5 = dataInput.readUnsignedShort();
        this.exports_table = new ModuleExports[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.exports_table[n4] = new ModuleExports(dataInput);
        }
        n4 = dataInput.readUnsignedShort();
        this.opens_table = new ModuleOpens[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.opens_table[n3] = new ModuleOpens(dataInput);
        }
        this.uses_count = dataInput.readUnsignedShort();
        this.uses_index = new int[this.uses_count];
        for (n3 = 0; n3 < this.uses_count; ++n3) {
            this.uses_index[n3] = dataInput.readUnsignedShort();
        }
        n3 = dataInput.readUnsignedShort();
        this.provides_table = new ModuleProvides[n3];
        for (int i = 0; i < n3; ++i) {
            this.provides_table[i] = new ModuleProvides(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requires_table;
    }

    public ModuleExports[] getExportsTable() {
        return this.exports_table;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opens_table;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.provides_table;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.module_name_index);
        dataOutputStream.writeShort(this.module_flags);
        dataOutputStream.writeShort(this.module_version_index);
        dataOutputStream.writeShort(this.requires_table.length);
        for (ModuleRequires moduleRequires : this.requires_table) {
            moduleRequires.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.exports_table.length);
        for (ModuleExports moduleExports : this.exports_table) {
            moduleExports.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.opens_table.length);
        for (ModuleOpens moduleOpens : this.opens_table) {
            moduleOpens.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.uses_index.length);
        for (int n : this.uses_index) {
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeShort(this.provides_table.length);
        for (ModuleProvides moduleProvides : this.provides_table) {
            moduleProvides.dump(dataOutputStream);
        }
    }

    @Override
    public String toString() {
        ConstantPool constantPool = super.getConstantPool();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Module:\n");
        stringBuilder.append("  name:    ").append(constantPool.getConstantString(this.module_name_index, (byte)19).replace('/', '.')).append("\n");
        stringBuilder.append("  flags:   ").append(String.format("%04x", this.module_flags)).append("\n");
        String string = this.module_version_index == 0 ? "0" : constantPool.getConstantString(this.module_version_index, (byte)1);
        stringBuilder.append("  version: ").append(string).append("\n");
        stringBuilder.append("  requires(").append(this.requires_table.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requires_table) {
            stringBuilder.append("    ").append(moduleRequires.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  exports(").append(this.exports_table.length).append("):\n");
        for (ModuleExports moduleExports : this.exports_table) {
            stringBuilder.append("    ").append(moduleExports.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  opens(").append(this.opens_table.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opens_table) {
            stringBuilder.append("    ").append(moduleOpens.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  uses(").append(this.uses_index.length).append("):\n");
        for (int n : this.uses_index) {
            String string2 = constantPool.getConstantString(n, (byte)7);
            stringBuilder.append("    ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        stringBuilder.append("  provides(").append(this.provides_table.length).append("):\n");
        for (ModuleProvides moduleProvides : this.provides_table) {
            stringBuilder.append("    ").append(moduleProvides.toString(constantPool)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        int n;
        Module module = (Module)this.clone();
        module.requires_table = new ModuleRequires[this.requires_table.length];
        for (n = 0; n < this.requires_table.length; ++n) {
            module.requires_table[n] = this.requires_table[n].copy();
        }
        module.exports_table = new ModuleExports[this.exports_table.length];
        for (n = 0; n < this.exports_table.length; ++n) {
            module.exports_table[n] = this.exports_table[n].copy();
        }
        module.opens_table = new ModuleOpens[this.opens_table.length];
        for (n = 0; n < this.opens_table.length; ++n) {
            module.opens_table[n] = this.opens_table[n].copy();
        }
        module.provides_table = new ModuleProvides[this.provides_table.length];
        for (n = 0; n < this.provides_table.length; ++n) {
            module.provides_table[n] = this.provides_table[n].copy();
        }
        module.setConstantPool(constantPool);
        return module;
    }
}

