/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NestHost
extends Attribute {
    private int host_class_index;

    public NestHost(NestHost nestHost) {
        this(nestHost.getNameIndex(), nestHost.getLength(), nestHost.getHostClassIndex(), nestHost.getConstantPool());
    }

    public NestHost(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)26, n, n2, constantPool);
        this.host_class_index = n3;
    }

    NestHost(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, 0, constantPool);
        this.host_class_index = dataInput.readUnsignedShort();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNestHost(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.host_class_index);
    }

    public int getHostClassIndex() {
        return this.host_class_index;
    }

    public void setHostClassIndex(int n) {
        this.host_class_index = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NestHost: ");
        String string = super.getConstantPool().getConstantString(this.host_class_index, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        NestHost nestHost = (NestHost)this.clone();
        nestHost.setConstantPool(constantPool);
        return nestHost;
    }
}

