/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.fault;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.fault.DetailType;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.fault.ServerSOAPFaultException;
import com.sun.xml.internal.ws.util.DOMUtil;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"faultcode", "faultstring", "faultactor", "detail"})
@XmlRootElement(name="Fault", namespace="http://schemas.xmlsoap.org/soap/envelope/")
class SOAP11Fault
extends SOAPFaultBuilder {
    @XmlElement(namespace="")
    private QName faultcode;
    @XmlElement(namespace="")
    private String faultstring;
    @XmlElement(namespace="")
    private String faultactor;
    @XmlElement(namespace="")
    private DetailType detail;

    SOAP11Fault() {
    }

    SOAP11Fault(QName qName, String string, String string2, Element element) {
        this.faultcode = qName;
        this.faultstring = string;
        this.faultactor = string2;
        if (element != null) {
            if ((element.getNamespaceURI() == null || "".equals(element.getNamespaceURI())) && "detail".equals(element.getLocalName())) {
                this.detail = new DetailType();
                for (Element element2 : DOMUtil.getChildElements(element)) {
                    this.detail.getDetails().add(element2);
                }
            } else {
                this.detail = new DetailType(element);
            }
        }
    }

    SOAP11Fault(SOAPFault sOAPFault) {
        this.faultcode = sOAPFault.getFaultCodeAsQName();
        this.faultstring = sOAPFault.getFaultString();
        this.faultactor = sOAPFault.getFaultActor();
        if (sOAPFault.getDetail() != null) {
            this.detail = new DetailType();
            Iterator iterator = sOAPFault.getDetail().getDetailEntries();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                this.detail.getDetails().add(element);
            }
        }
    }

    QName getFaultcode() {
        return this.faultcode;
    }

    void setFaultcode(QName qName) {
        this.faultcode = qName;
    }

    @Override
    String getFaultString() {
        return this.faultstring;
    }

    void setFaultstring(String string) {
        this.faultstring = string;
    }

    String getFaultactor() {
        return this.faultactor;
    }

    void setFaultactor(String string) {
        this.faultactor = string;
    }

    @Override
    DetailType getDetail() {
        return this.detail;
    }

    @Override
    void setDetail(DetailType detailType) {
        this.detail = detailType;
    }

    @Override
    protected Throwable getProtocolException() {
        try {
            SOAPFault sOAPFault = SOAPVersion.SOAP_11.getSOAPFactory().createFault(this.faultstring, this.faultcode);
            sOAPFault.setFaultActor(this.faultactor);
            if (this.detail != null) {
                Detail detail = sOAPFault.addDetail();
                for (Element element : this.detail.getDetails()) {
                    Node node = sOAPFault.getOwnerDocument().importNode(element, true);
                    detail.appendChild(node);
                }
            }
            return new ServerSOAPFaultException(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }
}

