/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class BootstrapMethod
implements Cloneable {
    private int bootstrap_method_ref;
    private int[] bootstrap_arguments;

    public BootstrapMethod(BootstrapMethod bootstrapMethod) {
        this(bootstrapMethod.getBootstrapMethodRef(), bootstrapMethod.getBootstrapArguments());
    }

    BootstrapMethod(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
        for (int i = 0; i < this.bootstrap_arguments.length; ++i) {
            this.bootstrap_arguments[i] = dataInput.readUnsignedShort();
        }
    }

    private BootstrapMethod(int n, int n2) {
        this(n, new int[n2]);
    }

    public BootstrapMethod(int n, int[] nArray) {
        this.bootstrap_method_ref = n;
        this.bootstrap_arguments = nArray;
    }

    public int getBootstrapMethodRef() {
        return this.bootstrap_method_ref;
    }

    public void setBootstrapMethodRef(int n) {
        this.bootstrap_method_ref = n;
    }

    public int[] getBootstrapArguments() {
        return this.bootstrap_arguments;
    }

    public int getNumBootstrapArguments() {
        return this.bootstrap_arguments.length;
    }

    public void setBootstrapArguments(int[] nArray) {
        this.bootstrap_arguments = nArray;
    }

    public final String toString() {
        return "BootstrapMethod(" + this.bootstrap_method_ref + ", " + this.bootstrap_arguments.length + ", " + Arrays.toString(this.bootstrap_arguments) + ")";
    }

    public final String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.bootstrap_method_ref, (byte)15);
        stringBuilder.append(Utility.compactClassName(string, false));
        int n = this.bootstrap_arguments.length;
        if (n > 0) {
            stringBuilder.append("\nMethod Arguments:");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\n  ").append(i).append(": ");
                stringBuilder.append(constantPool.constantToString(constantPool.getConstant(this.bootstrap_arguments[i])));
            }
        }
        return stringBuilder.toString();
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.bootstrap_method_ref);
        dataOutputStream.writeShort(this.bootstrap_arguments.length);
        for (int n : this.bootstrap_arguments) {
            dataOutputStream.writeShort(n);
        }
    }

    public BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

