/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)1, n, n2, constantPool);
        this.constantvalue_index = n3;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public void setConstantValueIndex(int n) {
        this.constantvalue_index = n;
    }

    @Override
    public String toString() {
        String string;
        Constant constant = super.getConstantPool().getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string = String.valueOf(((ConstantLong)constant).getBytes());
                break;
            }
            case 4: {
                string = String.valueOf(((ConstantFloat)constant).getBytes());
                break;
            }
            case 6: {
                string = String.valueOf(((ConstantDouble)constant).getBytes());
                break;
            }
            case 3: {
                string = String.valueOf(((ConstantInteger)constant).getBytes());
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = super.getConstantPool().getConstant(n, (byte)1);
                string = "\"" + Utility.convertString(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + constant);
            }
        }
        return string;
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.setConstantPool(constantPool);
        return constantValue;
    }
}

