/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleExports
implements Cloneable,
Node {
    private final int exports_index;
    private final int exports_flags;
    private final int exports_to_count;
    private final int[] exports_to_index;

    ModuleExports(DataInput dataInput) throws IOException {
        this.exports_index = dataInput.readUnsignedShort();
        this.exports_flags = dataInput.readUnsignedShort();
        this.exports_to_count = dataInput.readUnsignedShort();
        this.exports_to_index = new int[this.exports_to_count];
        for (int i = 0; i < this.exports_to_count; ++i) {
            this.exports_to_index[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleExports(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.exports_index);
        dataOutputStream.writeShort(this.exports_flags);
        dataOutputStream.writeShort(this.exports_to_count);
        for (int n : this.exports_to_index) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "exports(" + this.exports_index + ", " + this.exports_flags + ", " + this.exports_to_count + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.exports_index, (byte)20);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.exports_flags));
        stringBuilder.append(", to(").append(this.exports_to_count).append("):\n");
        for (int n : this.exports_to_index) {
            String string2 = constantPool.getConstantString(n, (byte)19);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

