/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.swing.SwingUtilities2;

public class BasicButtonUI
extends ButtonUI {
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private static final String propertyPrefix = "Button.";
    private static final Object BASIC_BUTTON_UI_KEY = new Object();
    private KeyListener keyListener = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        AppContext appContext = AppContext.getAppContext();
        BasicButtonUI basicButtonUI = (BasicButtonUI)appContext.get(BASIC_BUTTON_UI_KEY);
        if (basicButtonUI == null) {
            basicButtonUI = new BasicButtonUI();
            appContext.put(BASIC_BUTTON_UI_KEY, basicButtonUI);
        }
        return basicButtonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((AbstractButton)jComponent);
        this.installListeners((AbstractButton)jComponent);
        this.installKeyboardActions((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, ((AbstractButton)jComponent).getText());
    }

    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        this.defaultTextShiftOffset = UIManager.getInt(string + "textShiftOffset");
        if (abstractButton.isContentAreaFilled()) {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
        } else {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
        }
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string + "margin"));
        }
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
        Object object = UIManager.get(string + "rollover");
        if (object != null) {
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", object);
        }
        LookAndFeel.installProperty(abstractButton, "iconTextGap", 4);
    }

    protected void installListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addChangeListener(basicButtonListener);
        }
        if (abstractButton instanceof JToggleButton) {
            this.keyListener = this.createKeyListener();
            abstractButton.addKeyListener(this.keyListener);
            abstractButton.setFocusTraversalKeysEnabled(false);
            abstractButton.getActionMap().put("Previous", new SelectPreviousBtn());
            abstractButton.getActionMap().put("Next", new SelectNextBtn());
            abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
            abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
            abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
            abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
        }
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
        }
        if (abstractButton instanceof JToggleButton) {
            abstractButton.getActionMap().remove("Previous");
            abstractButton.getActionMap().remove("Next");
            abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
            abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
            abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
            abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
            if (this.keyListener != null) {
                abstractButton.removeKeyListener(this.keyListener);
                this.keyListener = null;
            }
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicButtonListener(abstractButton);
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        String string = this.layout(abstractButton, SwingUtilities2.getFontMetrics((JComponent)abstractButton, graphics), abstractButton.getWidth(), abstractButton.getHeight());
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (icon == null) {
            return;
        }
        Icon icon3 = null;
        if (buttonModel.isSelected() && (icon3 = abstractButton.getSelectedIcon()) != null) {
            icon = icon3;
        }
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected() && (icon2 = abstractButton.getDisabledSelectedIcon()) == null) {
                icon2 = icon3;
            }
            if (icon2 == null) {
                icon2 = abstractButton.getDisabledIcon();
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                this.clearTextShiftOffset();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            if (buttonModel.isSelected() && (icon2 = abstractButton.getRolloverSelectedIcon()) == null) {
                icon2 = icon3;
            }
            if (icon2 == null) {
                icon2 = abstractButton.getRolloverIcon();
            }
        }
        if (icon2 != null) {
            icon = icon2;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon.paintIcon(jComponent, graphics, rectangle.x + this.getTextShiftOffset(), rectangle.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        return BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        if (string == null || "".equals(string)) {
            return -1;
        }
        FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
        this.layout(abstractButton, fontMetrics, n, n2);
        return BasicHTML.getBaseline(abstractButton, BasicButtonUI.textRect.y, fontMetrics.getAscent(), BasicButtonUI.textRect.width, BasicButtonUI.textRect.height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        if (jComponent.getClientProperty("html") != null) {
            return Component.BaselineResizeBehavior.OTHER;
        }
        switch (((AbstractButton)jComponent).getVerticalAlignment()) {
            case 1: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
            case 0: {
                return Component.BaselineResizeBehavior.CENTER_OFFSET;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    private String layout(AbstractButton abstractButton, FontMetrics fontMetrics, int n, int n2) {
        Insets insets = abstractButton.getInsets();
        BasicButtonUI.viewRect.x = insets.left;
        BasicButtonUI.viewRect.y = insets.top;
        BasicButtonUI.viewRect.width = n - (insets.right + BasicButtonUI.viewRect.x);
        BasicButtonUI.viewRect.height = n2 - (insets.bottom + BasicButtonUI.viewRect.y);
        BasicButtonUI.textRect.height = 0;
        BasicButtonUI.textRect.width = 0;
        BasicButtonUI.textRect.y = 0;
        BasicButtonUI.textRect.x = 0;
        BasicButtonUI.iconRect.height = 0;
        BasicButtonUI.iconRect.width = 0;
        BasicButtonUI.iconRect.y = 0;
        BasicButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
    }

    private BasicButtonListener getButtonListener(AbstractButton abstractButton) {
        MouseMotionListener[] mouseMotionListenerArray = abstractButton.getMouseMotionListeners();
        if (mouseMotionListenerArray != null) {
            for (MouseMotionListener mouseMotionListener : mouseMotionListenerArray) {
                if (!(mouseMotionListener instanceof BasicButtonListener)) continue;
                return (BasicButtonListener)mouseMotionListener;
            }
        }
        return null;
    }

    private KeyListener createKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyHandler();
        }
        return this.keyListener;
    }

    private boolean isValidToggleButtonObj(Object object) {
        return object instanceof JToggleButton && ((JToggleButton)object).isVisible() && ((JToggleButton)object).isEnabled();
    }

    private void selectToggleButton(ActionEvent actionEvent, boolean bl) {
        Object object = actionEvent.getSource();
        if (!this.isValidToggleButtonObj(object)) {
            return;
        }
        ButtonGroupInfo buttonGroupInfo = new ButtonGroupInfo((JToggleButton)object);
        buttonGroupInfo.selectNewButton(bl);
    }

    private class ButtonGroupInfo {
        JToggleButton activeBtn = null;
        JToggleButton firstBtn = null;
        JToggleButton lastBtn = null;
        JToggleButton previousBtn = null;
        JToggleButton nextBtn = null;
        HashSet<JToggleButton> btnsInGroup = null;
        boolean srcFound = false;

        public ButtonGroupInfo(JToggleButton jToggleButton) {
            this.activeBtn = jToggleButton;
            this.btnsInGroup = new HashSet();
        }

        boolean containsInGroup(Object object) {
            return this.btnsInGroup.contains(object);
        }

        Component getFocusTransferBaseComponent(boolean bl) {
            return this.firstBtn;
        }

        boolean getButtonGroupInfo() {
            if (this.activeBtn == null) {
                return false;
            }
            this.btnsInGroup.clear();
            ButtonModel buttonModel = this.activeBtn.getModel();
            if (!(buttonModel instanceof DefaultButtonModel)) {
                return false;
            }
            DefaultButtonModel defaultButtonModel = (DefaultButtonModel)buttonModel;
            ButtonGroup buttonGroup = defaultButtonModel.getGroup();
            if (buttonGroup == null) {
                return false;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            if (enumeration == null) {
                return false;
            }
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!BasicButtonUI.this.isValidToggleButtonObj(abstractButton)) continue;
                this.btnsInGroup.add((JToggleButton)abstractButton);
                if (null == this.firstBtn) {
                    this.firstBtn = (JToggleButton)abstractButton;
                }
                if (this.activeBtn == abstractButton) {
                    this.srcFound = true;
                } else if (!this.srcFound) {
                    this.previousBtn = (JToggleButton)abstractButton;
                } else if (this.nextBtn == null) {
                    this.nextBtn = (JToggleButton)abstractButton;
                }
                this.lastBtn = (JToggleButton)abstractButton;
            }
            return true;
        }

        void selectNewButton(boolean bl) {
            if (!this.getButtonGroupInfo()) {
                return;
            }
            if (this.srcFound) {
                JToggleButton jToggleButton = null;
                if (bl) {
                    jToggleButton = null == this.nextBtn ? this.firstBtn : this.nextBtn;
                } else {
                    JToggleButton jToggleButton2 = jToggleButton = null == this.previousBtn ? this.lastBtn : this.previousBtn;
                }
                if (jToggleButton != null && jToggleButton != this.activeBtn) {
                    ButtonModel buttonModel = jToggleButton.getModel();
                    buttonModel.setPressed(true);
                    buttonModel.setArmed(true);
                    jToggleButton.requestFocusInWindow();
                    jToggleButton.setSelected(true);
                    buttonModel.setPressed(false);
                    buttonModel.setArmed(false);
                }
            }
        }

        void jumpToNextComponent(boolean bl) {
            if (!this.getButtonGroupInfo()) {
                if (this.activeBtn != null) {
                    this.lastBtn = this.activeBtn;
                    this.firstBtn = this.activeBtn;
                } else {
                    return;
                }
            }
            JToggleButton jToggleButton = this.activeBtn;
            Component component = this.getFocusTransferBaseComponent(bl);
            if (component != null) {
                if (bl) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(component);
                }
            }
        }
    }

    private class KeyHandler
    implements KeyListener {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JToggleButton jToggleButton;
            boolean bl;
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
            if (aWTKeyStroke != null && keyEvent.getSource() instanceof JToggleButton && ((bl = this.isFocusTraversalKey(jToggleButton = (JToggleButton)keyEvent.getSource(), 0, aWTKeyStroke)) || this.isFocusTraversalKey(jToggleButton, 1, aWTKeyStroke))) {
                keyEvent.consume();
                ButtonGroupInfo buttonGroupInfo = new ButtonGroupInfo(jToggleButton);
                buttonGroupInfo.jumpToNextComponent(bl);
            }
        }

        private boolean isFocusTraversalKey(JComponent jComponent, int n, AWTKeyStroke aWTKeyStroke) {
            Set<AWTKeyStroke> set = jComponent.getFocusTraversalKeys(n);
            return set != null && set.contains(aWTKeyStroke);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicButtonUI.this.selectToggleButton(actionEvent, true);
        }
    }

    private class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicButtonUI.this.selectToggleButton(actionEvent, false);
        }
    }
}

